/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.builder.AbstractIdentificationStep;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.function.Hanger;

public class IdentificationStep<C, I>
extends AbstractIdentificationStep<C, I> {
    AbstractIdentification<C, I> determineIdentification(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        if (entityMappingConfiguration.getInheritanceConfiguration() != null && entityMappingConfiguration.getPropertiesMapping().getMappedSuperClassConfiguration() != null) {
            throw new MappingConfigurationException("Combination of mapped super class and inheritance is not supported, please remove one of them");
        }
        if (entityMappingConfiguration.getKeyMapping() != null && entityMappingConfiguration.getInheritanceConfiguration() != null) {
            throw new MappingConfigurationException("Defining an identifier in conjunction with entity inheritance is not supported : " + Reflections.toString(entityMappingConfiguration.getEntityType()) + " defines identifier " + AccessorDefinition.toString(entityMappingConfiguration.getKeyMapping().getAccessor()) + " while it inherits from " + Reflections.toString(entityMappingConfiguration.getInheritanceConfiguration().getConfiguration().getEntityType()));
        }
        Hanger.Holder configurationDefiningIdentification = new Hanger.Holder();
        entityMappingConfiguration.inheritanceIterable().forEach(entityConfiguration -> {
            EntityMappingConfiguration.KeyMapping keyMapping = entityConfiguration.getKeyMapping();
            if (keyMapping != null && keyMapping instanceof EntityMappingConfiguration.SingleKeyMapping && ((EntityMappingConfiguration.SingleKeyMapping)keyMapping).getIdentifierPolicy() != null || keyMapping instanceof EntityMappingConfiguration.CompositeKeyMapping) {
                if (configurationDefiningIdentification.get() != null) {
                    throw new UnsupportedOperationException("Identifier policy is defined twice in hierarchy : first by " + Reflections.toString(((EntityMappingConfiguration)configurationDefiningIdentification.get()).getEntityType()) + ", then by " + Reflections.toString(entityConfiguration.getEntityType()));
                }
                configurationDefiningIdentification.set(entityConfiguration);
            }
        });
        EntityMappingConfiguration foundConfiguration = (EntityMappingConfiguration)configurationDefiningIdentification.get();
        if (foundConfiguration == null) {
            throw this.newMissingIdentificationException(entityMappingConfiguration.getEntityType());
        }
        EntityMappingConfiguration.KeyMapping foundKeyMapping = foundConfiguration.getKeyMapping();
        if (foundKeyMapping instanceof EntityMappingConfiguration.SingleKeyMapping) {
            return AbstractIdentification.forSingleKey(foundConfiguration);
        }
        if (foundKeyMapping instanceof EntityMappingConfiguration.CompositeKeyMapping) {
            IdentificationStep.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)foundKeyMapping);
            return AbstractIdentification.forCompositeKey(foundConfiguration, (EntityMappingConfiguration.CompositeKeyMapping)foundKeyMapping);
        }
        throw new MappingConfigurationException("Unknown key mapping : " + foundKeyMapping);
    }

    @VisibleForTesting
    static void assertCompositeKeyIdentifierOverridesEqualsHashcode(EntityMappingConfiguration.CompositeKeyMapping<?, ?> compositeKeyIdentification) {
        Class compositeKeyType = AccessorDefinition.giveDefinition(compositeKeyIdentification.getAccessor()).getMemberType();
        try {
            compositeKeyType.getDeclaredMethod("equals", Object.class);
            compositeKeyType.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MappingConfigurationException("Composite key identifier class " + Reflections.toString((Class)compositeKeyType) + " seems to have default implementation of equals() and hashcode() methods, which is not supported (identifiers must be distinguishable), please make it implement them");
        }
    }
}

